'
' Instances of this class represent an Wordcombination non-terminal
' token. 
'
Public Class WordCombination
    Implements ICombination
    Private word As String

    '
    ' constructor
    '
    ' word - The word that this combination requires
    '        in a string
    Public Sub New(ByVal word As String)
        Me.word = word
    End Sub

    '
    ' If the given string contains the word that this
    ' WordCombination object requires, this method returns an
    ' array of the offsets where the word occurs in the string.
    ' Otherwise, this method returns Nothing.
    '
    ' s - The string that this method will search for
    '     the word it requires.
    Public Function Contains(ByVal s As String) As Integer() _
     Implements ICombination.Contains
        Dim indexCount As Integer = 0 ' Number of occurrences found so far.
        Dim array(16) As Integer ' collect offsets in this array
        Dim index As Integer = s.IndexOf(word) ' The offset to start searching for the
        ' next occurrence.
        While index >= 0
            ' ensure array is large enough
            If indexCount >= array.Length Then
                Dim largerArray(array.Length * 2) As Integer
                System.Array.Copy(array, 0, largerArray, 0, indexCount)
                array = largerArray
            End If
            index = s.IndexOf(word, index)
            array(indexCount) = index
            indexCount += 1
        End While ' while (index >= 0)
        If indexCount = 0 Then
            Return Nothing
        End If
        If indexCount = array.Length Then
            Return array
        End If
        Dim finishedArray(array.Length) As Integer
        System.Array.Copy(array, 0, finishedArray, 0, array.Length)
        Return finishedArray
    End Function 'Contains
End Class 'WordCombination